import {FlatList, SafeAreaView} from "react-native";
import {StatusBar} from "expo-status-bar";
import {useState} from "react";
import {Device} from "react-native-ble-plx";
import ScanControl, {DeviceExtendedByUpdateTime} from "./ScanControl";
import {BleDevice} from "./BleDevice";


export default function Main() {
    const [copilotSN, setCopilotSN] = useState<string>("")
    const [foundDevices, setFoundDevices] = useState<DeviceExtendedByUpdateTime[]>([])

    const deviceRender = (device: Device) => {
        return <BleDevice
            key={device.id}
            device={device}
            copilotSN={copilotSN}
            setCopilotSN={setCopilotSN}
        />
    }

    return (
        <SafeAreaView style={{flex: 1}}>
            <ScanControl copilotSN={copilotSN} setFoundDevices={setFoundDevices}/>
            <FlatList
                style={{flex: 1}}
                data={foundDevices}
                renderItem={({item}) => deviceRender(item)}
                keyExtractor={device => device.id}
            />
            <StatusBar style="auto"/>
        </SafeAreaView>
    );
}